!grep '^EXP' snowflake-shovel-bw > snowflake-exp
!grep '^[0-9]' snowflake-shovel-bw > snowflake-data

clear;

global def_exp def_key def_value
global data_exp data_requests data_time
global stat_meantime stat_requests

[junk, def_exp, def_key, def_value] = ...
	textread('snowflake-exp', '%s %d %s %s');
[data_exp, data_requests, data_time, junk] = ...
	textread('snowflake-data', '%d %d %f %d');

% fix broken offsets
def_exp = def_exp+1;
data_exp = data_exp+1;

% for each experiment, compute a single mean (and cv)
ue = unique(def_exp);
for uei = 1:length(ue),
	expnumi = ue(uei);
	indices = find(data_exp==expnumi);
	times = data_time(indices);
	times = times(2:end);	% disregard first time, it's always bogus
	stat_meantime(expnumi) = mean(times);
	cv(expnumi) = std(times)/stat_meantime(expnumi);
	stat_requests(expnumi) = data_requests(indices(1));
end

clf;
hold on;

% each line varies numberOfConnections
% [m,r] = datawhere({'fileLength','100';'cacheContext','true'});
% d(:,1) = (m./r)';
% [m,r] = datawhere({'fileLength','1000';'cacheContext','true'});
% d(:,2) = (m./r)';
% [m,r] = datawhere({'fileLength','10000';'cacheContext','true'});
% d(:,3) = (m./r)';
% [m,r] = datawhere({'fileLength','100000';'cacheContext','true'});
% d(:,4) = (m./r)';
% plot(d);

% each line varies numberOfConnections
% d = [];
% i = 1;
% [m,r] = datawhere({'numberOfConnections','1';'cacheContext','true'});
% d(:,1) = (m./r)';
% [m,r] = datawhere({'numberOfConnections','5';'cacheContext','true'});
% d(:,2) = (m./r)';
% [m,r] = datawhere({'numberOfConnections','10';'cacheContext','true'});
% d(:,3) = (m./r)';
% [m,r] = datawhere({'numberOfConnections','50';'cacheContext','true'});
% d(:,4) = (m./r)';
% [m,r] = datawhere({'numberOfConnections','100';'cacheContext','true'});
% d(:,5) = (m./r)';
% plot(d);

d = stat_meantime./stat_requests;
plot(d);

