% present the results of my very rough timing experiments for RMI overheads
% for section "performance of name resolution."
exp = get_experiments('timedata/rmiovh-1');

% select experiments by experimentNum
% get a rundown with: [exp.experimentID, exp.conf, exp.desc]
valI =			[ 3, 7, 4, 8, 12, 17, 11, 16, 13, 18 ];
timerBaseLineI= [ 2, 6, 2, 6,  9, 14,  9, 14,  9, 14 ];
val = exp.meanPerRequest(valI);
bsl = exp.meanPerRequest(timerBaseLineI);
val = reshape(val - bsl, 1, length(val));
labels = {'C function call'; 'C getpid()'; 'Java local method call'; ...
		'Java Serialize'; 'Java Remote method call'};

% display experiments
clf
n = length(val);
xpos = (1:2:n-1)/2;
xpos = [xpos'; xpos'-0.25];
xpos = sort(xpos(:))';
colors = repmat([0.75 0.75 0.75; 1 1 1], 6, 1);
ph = log_bar_graph(xpos, val, {}, {}, colors);
legend(ph(2:-1:1), 'optimized', 'unoptimized', 4);
set(gca,'xscale','log');
set(gca,'xlim',[10^-9.1 1]);
set(gca,'xtick',[1e-9 1e-6 1e-3 1]);
%set(gca,'xticklabel',strvcat('1 ns', '1 \mu s', '1 ms', '1 s'));
set(gca,'xticklabel',[]);
set(gca,'ytick',[]);
set(gca,'ycolor',[1 1 1]);
set(gca,'ylim',[min(xpos)-0.5 max(xpos)+0.5]);
%set(gca,'CameraUpVector',[-1 0 0])
set(gca,'YAxisLocation','right')  
th = text([1e-9 1e-6 1e-3 1], -0.4*[1 1 1 1], ...
	strvcat('1 ns', '1 \mus', '1 ms', '1 s'));
set(th, 'HorizontalAlignment', 'center');
set(gca,'xgrid','on');

for i=1:2:n,
	minv = min(val(i), val(i+1));
	maxv = max(val(i), val(i+1));
	%if (minv>1e-4),
	if (1),
		th = text(10^(log10(minv)-0.1), xpos(i)+0.25, char(labels((i+1)/2)));
		set(th, 'HorizontalAlignment', 'right');
	else
		th = text(10^(log10(minv)+0.1), xpos(i)+0.375, char(labels((i+1)/2)));
		set(th, 'HorizontalAlignment', 'left');
	end
end

set(gcf,'paperposition',[1 1 5 3]);
print(1, '-dps2', 'ps/naming-perf.eps');
