function lh = plot_trace(trace, plotColor, yoff)
t = 1;
host = 2;
syn = 3;
fin = 5;
id = 7;
red = [1 0 0];
green = [0 1 0];
blue = [0 0 1];
color = (~trace(:,syn) & ~trace(:,fin))*blue + trace(:,syn)*green + trace(:,fin)*red;

trace(:,t) = trace(:,t) - trace(19,t);

%clf
figure(1);
hold on;
sessions = unique(trace(:,id));
for i=1:length(sessions),
	sessionID = sessions(i);
	sessionInd = find(trace(:,id)==sessionID);
	sessionTrace = trace(sessionInd,:);
	sessionTimes = sessionTrace(:,t);
	xdata = sessionTimes;
	ydata = i*ones(size(sessionTimes))+yoff;
	plot(xdata, ydata, [plotColor,'-']);

	toPackets = find((sessionTrace(:,host)==0));
	plot(xdata(toPackets),ydata(toPackets)-1/6,[plotColor,'.']);
	fromPackets = find((sessionTrace(:,host)==1));
	plot(xdata(fromPackets),ydata(fromPackets)+1/6,[plotColor,'.']);

	startPacket = find((sessionTrace(:,host)==0) & sessionTrace(:,syn)==1);
	plot(xdata(startPacket),ydata(startPacket),'md');
	endPacket = find((sessionTrace(:,host)==1) & sessionTrace(:,fin)==1);
	plot(xdata(endPacket),ydata(endPacket),'rd');
	if (mod(i,50)==0),
		%drawnow;
	end
end

% fromx = trace(:,t);
% tox = trace(:,t);
% fromy = trace(:,host);
% toy = 1-trace(:,host);
% 
e1 = find(trace(:,syn) & trace(:,host)==0);
e2 = find(trace(:,syn) & trace(:,host)==1);
e3 = find(trace(:,fin) & trace(:,host)==1);
e4 = find(trace(:,fin) & trace(:,host)==0);

figure(2); hold on;

%openToClose = trace(e3,t)-trace(e1,t);
%disp(sprintf('mean time between client open and server close: %f', ...
%	mean(openToClose) ));
%plot(openToClose+yoff, [plotColor,'*']);
%
%closeToOpen = trace(e1(2:end),t)-trace(e3(1:end-1),t);
%disp(sprintf('mean time between server close and next client open: %f', ...
%	mean(closeToOpen) ));
%plot(closeToOpen+yoff, [plotColor,'o']);

csend = find(trace(:,host)==0);
ssend = find(trace(:,host)==1);
if (length(csend)>length(ssend)),
	diff= length(csend)-length(ssend);
	csend = csend(diff+1:end);
end
ctos = trace(ssend,t) - trace(csend,t);
disp(sprintf('mean time between client send and server reply: %f', ...
	mean(ctos) ));
plot(ctos+yoff, [plotColor,'*']);

stoc = trace(csend(2:end),t) - trace(ssend(1:end-1),t);
disp(sprintf('mean time between server reply and client send: %f', ...
	mean(stoc) ));
plot(stoc+yoff, [plotColor,'o']);
% 
% lh = {e1,e2,e3,e4};

% lh = plot([fromx';tox'], [fromy';toy'], 'b');
% set(lh(logical(trace(:,syn))),'Color',green);
% set(lh(logical(trace(:,fin))),'Color',red);

% base(2,1:20)
% dir(:,1:20)
% quiver(base(1,:), base(2,:), dir(1,:), dir(2,:));
% set(gca,'ylim',[-3,4]);
