function patchHandles = log_bar_graph(x, height, top_labels, bot_labels, colors)
%patch(x, zeros(size(x)), height);
w = 0.5;

xpatch = [x-w/2; x-w/2; x+w/2; x+w/2];
ypatch = [logZeros(1,length(height));
		height;
		height;
		logZeros(1,length(height))];
zpatch = zeros(4,length(height));
patchHandles = [];
for i = 1:length(x),
	ph = patch(ypatch(:,i), xpatch(:,i), zpatch(:,i), colors(i,:));
	patchHandles = [patchHandles; ph];
end
ylim = get(gca,'ylim');
text(x-w/2, height+get(gca,'ylim')*[-1 1]'*0.02, top_labels);
%set(gca, 'xtick', x);
%set(gca, 'xticklabel', bot_labels);

% return a zero matrix, or almost-zero matrix for a logscale plot
function m = logZeros(r, c)
m = ones(r, c)*1e-20;
