function str = imprecision(value, digits)
% returns a string that is the 'value' with 'digits' digits of
% precision. like sprintf('%g',...), but the string is never
% in exponential notation.

factor = 10^(floor(log10(value))+1-digits);
minfrac = -floor(log10(value))+digits-1;
x = round(value/factor)*factor;
if (minfrac>0),
	cstr = sprintf('%s0.%df', '%', minfrac);
else
	cstr = '%0g';
end
str = sprintf(cstr, x);
