function gentable(exp, tdesc)

[fid,msg] = fopen(strcat('tables/',tdesc.tablename,'.tex'), 'w');
if (fid<=0),
	error(msg);
end

if (~isfield(tdesc, 'wantSlope')),
	tdesc.wantSlope = 1;
end

% figure out which data columns we'll want
bases = tdesc.bases;
	% read the rows across. Stupid defTable syntax
rows = extractRows(exp, bases);

mciExi = log10(rows.mci_value./rows.m_value)>-3;
bciExi = log10(rows.bci_value./rows.b_value)>-3;
	% TODO: turn down that sensitivity
sgmExi = log10(rows.sgm_value./rows.b_value)>-3;
rrExi = rows.rr_value<0.985;	% anything higher rounds to 0.99

needMciCol = sum(mciExi)>0;
needBciCol = sum(bciExi)>0;
needSgmCol = sum(sgmExi)>0;
needRrCol = sum(rrExi)>0;

needSpec = {'r','rl'};
needSpec2 = {'','r'};
amper = {'', ' & '};
sgmColLabels = {'', '& \multicolumn{1}{c}{$\sigma$}'};
sgmColUnitss = {'', sprintf('& \\multicolumn{1}{c}{\\ws{%s}}',rows(1).b_units(1,:))};
rrColLabels = {'', '& \multicolumn{1}{c}{$R^2$}'};
rrColUnitss = {'', '& \multicolumn{1}{c}{}'};

localityColumn = isequal(char(tdesc.collabels(2,end)),'locality');
remainingColLabels = tdesc.collabels(:,1:end-localityColumn);

labelcols = repmat('l',1,size(tdesc.collabels,2)-localityColumn);
if (tdesc.wantSlope),
	mcols = char(needSpec(needMciCol+1));
	mColLabel = sprintf('& \\multicolumn{%d}{c}{\\ws{%s}}', ...
		1+needMciCol, tdesc.dataLabels.mlabel);
	mColUnits = sprintf('& \\multicolumn{%d}{c}{\\ws{%s}}', ...
		1+needMciCol, rows(1).m_units(1,:));
	rrcol = char(needSpec2(needRrCol+1));
	rrColLabel = rrColLabels{needRrCol+1};
	rrColUnits = rrColUnitss{needRrCol+1};
else
	mcols = '';
	mColLabel = '';
	mColUnits = '';
	rrcol = '';
	rrColLabel = '';
	rrColUnits = '';
end

bcols = char(needSpec(needBciCol+1));
bColLabel = sprintf('& \\multicolumn{%d}{c}{\\ws{%s}}', ...
	1+needBciCol, tdesc.dataLabels.blabel);
bColUnits = sprintf('& \\multicolumn{%d}{c}{\\ws{%s}}', ...
	1+needBciCol, rows(1).b_units(1,:));

sgmcol = char(needSpec2(needSgmCol+1));
sgmColLabel = sgmColLabels{needSgmCol+1};
sgmColUnits = sgmColUnitss{needSgmCol+1};

coldef = strcat(labelcols, '|', bcols, mcols, sgmcol, rrcol);

% assemble the top row of the column labels

colLabels1(3,:) = remainingColLabels(1,:);
colLabels1(1,:) = cellstr('&');
colLabels1(2,:) = cellstr('\ws{');
colLabels1(4,:) = cellstr('}');
colLabels1(1,1) = cellstr('');
colLabels1 = strcat(colLabels1{:});
colLabels1 = strcat(colLabels1, bColLabel, mColLabel, sgmColLabel, rrColLabel, '\\');

% assemble the second (units) row of the column labels
colLabels2(3,:) = remainingColLabels(2,:);
colLabels2(1,:) = cellstr('&');
colLabels2(2,:) = cellstr('\ws{');
colLabels2(4,:) = cellstr('}');
colLabels2(1,1) = cellstr('');
colLabels2 = strcat(colLabels2{:});
colLabels2 = strcat(colLabels2, bColUnits, mColUnits, sgmColUnits, rrColUnits, '\\');

fprintf(fid, '\\begin{center}\n');
fprintf(fid, '\\begin{tabular}{%s}\n', coldef);
fprintf(fid, '%s\n', colLabels1);
fprintf(fid, '%s\n', colLabels2);
fprintf(fid, '%s\n', '\hline');
remoteParen = '\rowRem{remote}';
% output each row, one at a time
for di = 1:size(rows.b_value,1),
	rowLabels = {};
	rowKind = '\rowLoc{';
	if (localityColumn & isequal(char(tdesc.rowlabels(di,end)),'remote')),
		rowKind = '\rowRem{';
		num = size(tdesc.rowlabels,2)-1;
		rowLabels = sprintf('\\multicolumn{%d}{r|}{\\ws{%s}}', num, remoteParen);
	else
		rowLabels(3,:) = tdesc.rowlabels(di,1:end-localityColumn);
		rowLabels(1,:) = cellstr(' & ');
		rowLabels(2,:) = cellstr([rowKind,'\ws{']);
		rowLabels(4,:) = cellstr('}}');
		rowLabels(1,1) = cellstr('');
		rowLabels = strcat(rowLabels{:});
	end
	rowLabels = [rowLabels, ' & ', rowKind, imprecision(rows.b_value(di),2), '}'];
	rowLabels = [rowLabels, char(amper(needBciCol+1))];
	if (bciExi(di)),
		rowLabels = [rowLabels, '$\pm$ ', rowKind, imprecision(rows.bci_value(di),2), '}'];
	end

	if (tdesc.wantSlope),
		rowLabels = [rowLabels, ' & ', rowKind, imprecision(rows.m_value(di),2),'}'];
		rowLabels = [rowLabels, char(amper(needMciCol+1))];
		if (mciExi(di)),
			rowLabels = [rowLabels, ' $\pm$ ', rowKind, imprecision(rows.mci_value(di),2), '}'];
		end
	end

	rowLabels = [rowLabels, char(amper(needSgmCol+1))];
	if (sgmExi(di)),
		rowLabels = [rowLabels, rowKind, imprecision(rows.sgm_value(di),2), '}'];
	end

	if (tdesc.wantSlope),
		rowLabels = [rowLabels, char(amper(needRrCol+1))];
		if (rrExi(di)),
			rowLabels = [rowLabels, rowKind, imprecision(rows.rr_value(di),2), '}'];
		end
	end

	rowLabels = [rowLabels, ' \\'];
	fprintf(fid, '%s\n', rowLabels);
end
fprintf(fid, '\\end{tabular}\n');
fprintf(fid, '\\end{center}\n');

fclose(fid);
