function flat_graph(x, height, top_labels, bot_labels, colors)
%patch(x, zeros(size(x)), height);
w = 0.5;

xpatch = [x-w/2; x-w/2; x+w/2; x+w/2];
ypatch = [zeros(1,length(height));
		height;
		height;
		zeros(1,length(height))];
zpatch = zeros(4,length(height));
for i = 1:length(x),
	patch(xpatch(:,i), ypatch(:,i), zpatch(:,i), colors(i,:));
end
ylim = get(gca,'ylim');
th = text(x, height+(get(gca,'ylim')*[-1 1]')*0.03, top_labels);
set(th,'HorizontalAlignment', 'center');
set(gca, 'xtick', x);
set(gca, 'xticklabel', bot_labels);
