function [rows] = extractRows(aggexp, rownames)
% extract all table data for rownames from aggexp

fns1 = {'value','m';
	'value','mci';
	'value','b',
	'value','bci';
	'value', 'rr';
	'value', 'sgm'};
fns2 = fns1;
fns2(:,1) = {'units'};
fns = [fns1; fns2];

rows = [];
for fni=1:size(fns,1),
	fn = fns(fni,:);
	fncat = strcat(fn(2),'_',fn(1));
	col = extractColumn(aggexp, rownames, char(fn(1)), char(fn(2)));
	rows = setfield(rows, char(fncat), col);
end
