function [table] = defTables()
% define the specifications for the tables that will appear in .tex format

connBw.blabel = 'request';
connBw.mlabel = 'copy';

connReq.blabel = 'connect';
connReq.mlabel = 'request';

table = [];
table(1).tablename = 'table-http-baseline';
table(1).wantSlope = 1;
table(1).bases = {
	'fastgetbw_loc_apache';
	'fastgetbw_rem_apache';
	'httpbw_loc_apache';
	'httpbw_rem_apache';
	'httpbw_loc_simple';
	'httpbw_rem_simple';
	'httpbw_loc_Jetty';
	'httpbw_rem_Jetty' };
table(1).collabels = {
	'','','network';
	'client', 'server', 'locality'};
table(1).dataLabels = connBw;
table(1).rowlabels = {
	'C','Apache','local';
	'','','remote';
	'Java','Apache','local';
	'','','remote';
	'','Java','local';
	'','','remote';
	'','Jetty','local';
	'','','remote'};

table(2).tablename = 'table-http11';
table(2).wantSlope = 1;
table(2).bases = {
	'httpIIreq_loc_apache';
	'httpIIreq_rem_apache';
	'httpIIreq_loc_jetty';
	'httpIIreq_rem_jetty' };
table(2).collabels = {
	'','network';
	'server', 'locality'};
table(2).dataLabels = connReq;
table(2).rowlabels = {
	'Apache','local';
	'','remote';
	'Jetty','local';
	'','remote' };

table(3).tablename = 'table-snowflake-authz';
table(3).wantSlope = 1;
table(3).bases = {
	'sfbw_sh_loc_full';
	'sfbw_sh_rem_full';
	'sfbw_sh_loc_ident';
	'sfbw_sh_rem_ident';
	'sfbw_sh_loc_macs';
	'sfbw_sh_rem_macs' };
table(3).collabels = {
	'','network';
	'requests', 'locality'};
table(3).dataLabels = connBw;
table(3).rowlabels = {
	'signed','local';
	'','remote';
	'identical','local';
	'','remote';
	'MAC opt','local';
	'','remote' };

table(4).tablename = 'table-snowflake-signs';
table(4).wantSlope = 1;
table(4).bases = {
	'sfserverauth_loc_none';
	'sfserverauth_rem_none';
	'sfserverauth_loc_sign';
	'sfserverauth_rem_sign';
	'sfserverauth_loc_cacSig';
	'sfserverauth_rem_cacSig';
	'sfserverauth_loc_sigChk';
	'sfserverauth_rem_sigChk';
	'sfserverauth_loc_cacChk';
	'sfserverauth_rem_cacChk' };
table(4).collabels = {
	'server', 'client','network';
	'behavior', 'behavior', 'locality'};
table(4).dataLabels = connBw;
table(4).rowlabels = {
	'none', 'ignore', 'local',
	'', '', 'remote';
	'sign', 'ignore', 'local',
	'', '', 'remote';
	'cache', 'ignore', 'local',
	'', '', 'remote';
	'sign', 'verify', 'local',
	'', '', 'remote';
	'cache', 'verify', 'local',
	'', '', 'remote';
	};

table(5).tablename = 'table-ssl-bw';
table(5).wantSlope = 1;
table(5).bases = {
	'sslIIbw_apache_loc_full';
	'sslIIbw_apache_rem_full';
	'sslIIbw_apache_loc_cacCon';
	'sslIIbw_apache_rem_cacCon';
	'sslIIbw_apache_loc_cacSes';
	'sslIIbw_apache_rem_cacSes';
	'sslIIbw_jetty_loc_full';
	'sslIIbw_jetty_rem_full';
	'sslIIbw_jetty_loc_cacCon';
	'sslIIbw_jetty_rem_cacCon';
	'sslIIbw_jetty_loc_cacSes';
	'sslIIbw_jetty_rem_cacSes';
	};
table(5).collabels = {
	'', '', 'network';
	'server', 'cache', 'locality'};
table(5).dataLabels = connBw;
table(5).rowlabels = {
	'Apache', 'none', 'local',
	'', '', 'remote';
	'', 'context', 'local',
	'', '', 'remote';
	'', 'session', 'local',
	'', '', 'remote';
	'Jetty', 'none', 'local',
	'', '', 'remote';
	'', 'context', 'local',
	'', '', 'remote';
	'', 'session', 'local',
	'', '', 'remote';
	};

table(6).tablename = 'table-ssl-req';
table(6).wantSlope = 1;
table(6).bases = {
	'sslreq_loc_apache';
	'sslreq_rem_apache';
	'sslreq_loc_jetty';
	'sslreq_rem_jetty' };
table(6).collabels = {
	'','network';
	'server','locality'};
table(6).dataLabels = connReq;
table(6).rowlabels = {
	'Apache','local';
	'','remote';
	'Jetty','local';
	'','remote' };

table(7).tablename = 'table-rmibw';
table(7).wantSlope = 1;
table(7).bases = {
	'rmibw_loc_rmi';
	'rmibw_rem_rmi';
	'rmibw_loc_rmissh';
	'rmibw_rem_rmissh';
	'rmibw_loc_rmisf';
	'rmibw_rem_rmisf' };
table(7).collabels = {
	'','network';
	'protocol','locality'};
table(7).dataLabels = connBw;
table(7).rowlabels = {
	'RMI','local';
	'','remote';
	'ssh alone','local';
	'','remote';
	'Snowflake','local';
	'','remote' };

table(8).tablename = 'table-rmisetup';
table(8).wantSlope = 1;
table(8).bases = {
	'rmisetup_loc_nocache';
	'rmisetup_rem_nocache';
	'rmisetup_loc_clientcache';
	'rmisetup_rem_clientcache';
	'rmisetup_loc_servercache';
	'rmisetup_rem_servercache' };
table(8).collabels = {
	'proofs','network';
	'cached','locality'};
table(8).dataLabels = connBw;
table(8).rowlabels = {
	'none','local';
	'','remote';
	'client','local';
	'','remote';
	'server','local';
	'','remote' };

table(9) = table(5);
table(9).tablename = 'table-ssl-bw-short';
table9select = [3:6 9:12];
table(9).bases = table(5).bases(table9select);
table(9).rowlabels = table(5).rowlabels(table9select,:);
table(9).rowlabels(1,1) = cellstr('Apache');
table(9).rowlabels(5,1) = cellstr('Jetty');

table(10) = table(8);
table(10).tablename = 'table-rmisetup-short';
table(10).bases = {
	'rmisetup_loc_nocache';
	'rmisetup_rem_nocache';
	'rmisetup_loc_clientcache';
	'rmisetup_rem_clientcache' };
table(10).rowlabels = {
	'none','local';
	'','remote';
	'client','local';
	'','remote' };
