function bar_graph(data, params)
% bar_graph(data, depth_labels)
% Given a set of data, draws a 3D bar graph, colored by rows of depth,
% and labels each bar with its height.
% patches = [px pd ph]; pd is depth, ph is height
%
% So to stack a series of bars, they should have the same px and different pd.
%
% When params.depth_labels are supplied, the 'pd' field of the data will be
% used to index the depth_labels to draw a color legend.
% (hence pd has to be >=1)
%
% When params.zlim is supplied, it will clip the top of the graph

% sort patches by depth
[y,i] = sort(data(:,2));
data = data(end-i+1,:);

px = data(:,1);
pd = data(:,2);
ph = data(:,3);

xp = [-0.25 -0.25 0.25 0.25];
yp = [0 0 0 0];
zp = [0 1 1 0];

x = [xp(1)+px, xp(2)+px, xp(3)+px, xp(4)+px]';
y = [yp(1)+pd, yp(2)+pd, yp(3)+pd, yp(4)+pd]';
z = [zp(1)*ph, zp(2)*ph, zp(3)*ph, zp(4)*ph]';

mind = min(pd);
maxd = max(pd);
if (mind==maxd),
	colors = pd'.*0+1;
else
	colors = floor(31*(pd-mind)/(maxd-mind)+1)';
end

labels = [];
for i=1:length(ph),
	% too bad sprintf isn't vectorized in a useful way... grr.
	labels = strvcat(labels, sprintf('%5.2f', ph(i)));
end

clf;
% do each row separately so it can get legended.
dub = unique(pd);
legend_ph = [];
legend_txt = [];
for i=1:length(dub),
	datai = find(pd==dub(i));
	patch_ha = patch(x(:,datai), y(:,datai), z(:,datai), repmat(colors(datai),4,1));
	if (isfield(params,'depth_labels')),
		legend_ph = [legend_ph; patch_ha];
		legend_txt = [legend_txt; params.depth_labels(dub(i),:)];
	end
end
if (length(legend_ph)>0),
	legend(legend_ph, legend_txt, 2);
end
view(3, 5);
%text_x = (x(2,:)+x(3,:))/2;
zlim = get(gca,'zlim');
if (isfield(params,'zlim')),
	zlim(2) = params.zlim;
end
set(gca,'zlim',zlim);
	
zspan = zlim(2)-zlim(1);
text_ha = text(x(1,:), y(1,:), min(z(2,:)+zspan*0.01, zlim(2)), labels);
set(text_ha,'fontsize',8);
