function analyze_cv(sn,cutoff)

% cutoff = 3*std(sn.cv);

badguys = find(sn.cv>cutoff);

disp(sprintf('You can eliminate all CVs greater than %6.4f by redoing experiments:', cutoff));
disp(sprintf('  %d  (cv=%6.4f)\n', [sn.experimentIDNum(badguys), sn.cv(badguys)]'));

commaList = [];
for i=1:length(badguys),
	commaList = [commaList,sprintf('%d', sn.experimentIDNum(badguys(i))),','];
end
commaList = commaList(1:end-1);	% snip trailing ','
disp(commaList);
