package timingexp;

import java.io.*;
import java.rmi.*;
import java.rmi.server.*;

import rmi.*;

/**
 * A Snowflake-authorized version of TestRMICall, used with RMIExp.<p>
 *
 * The ssh/Snowflake code in here was basically stripped from
 * relational.InternalDatabase.
 */
public abstract class TestRMICallImpl
	extends UnicastRemoteObject
	implements TestRMICall {

	File base = new File("/usr/local/apache/htdocs/");

	protected TestRMICallImpl()
		throws RemoteException {
	}

	protected TestRMICallImpl(int port,
		RMIClientSocketFactory csf, RMIServerSocketFactory ssf)
		throws RemoteException {
		// required by subclasses
		super(port, csf, ssf);
	}

	public Object requestFile(String path)
		throws RemoteException {
		try {
			File file = new File(base, path);
	
			// RMI imposes a 64k limit on file length
			if (false && file.length()>63000L) {
				throw new RuntimeException("File length too long for a single "
					+"RMI call: "+file.length());
			}
			int len = (int) file.length();
			
			byte[] buf = new byte[len];
			FileInputStream fis = new FileInputStream(file);
			int rc = fis.read(buf);
			fis.close();
			if (rc!=len) {
				throw new RuntimeException("Short read. read: "+rc
					+" expected: "+len);
			}

			// randomly corrupt the data to change the checksum
//			buf[buf.length>>1] = (byte) 'Q';
//			return new TestResult(buf);

			return buf;
		} catch (Exception ex) {
			throw new RuntimeException(ex.toString());
		}
	}
}
