package ssl;

import java.io.*;
import java.net.*; 
import java.rmi.server.*; 
import COM.claymoresystems.ptls.*;

/**
 * A factory to create RMI server (listener) sockets. Remote objects
 * specify this factory class when they invoke UnicastRemoteObject's
 * constructor to demand that clients connect to the object via an SSL
 * channel. 
 */
public class SSLServerSocketFactory 
	implements RMIServerSocketFactory, Serializable { 

	transient SSLContext context;

	public SSLServerSocketFactory(SSLContext context) {
		this.context = context;
	}

	public ServerSocket createServerSocket(int port) 
		throws IOException { 
		// return new DebugSSLServerSocket(context, port); 
		return new SSLServerSocket(context, port); 
	} 

	private void writeObject(ObjectOutputStream out)
		throws IOException {
		System.err.println(this.getClass()
			+" writeObject sends nothing");
	}

	private void readObject(ObjectInputStream out)
		throws IOException {
		// no non-transient state to read...
		System.err.println(this.getClass()
			+" readObject supplies fresh, hokey SSLContext");
		context = new SSLContext();	// transient field
	}
} 
