package ssl;

import java.io.*;
import java.net.*; 
import java.rmi.server.*; 
import COM.claymoresystems.ptls.*;
import COM.claymoresystems.sslg.*;
import Tools.*;

/**
 * A SSLClientSocketFactory lives on the client side of the RMI
 * connections, and creates SSL connections back to the server to
 * transmit RMI messages.
 */
public class SSLClientSocketFactory 
	implements RMIClientSocketFactory, Serializable { 

	transient SSLContext context;

	public SSLClientSocketFactory() {
		System.err.println(getClass()+" USELESS ctor runs");
	}

	public SSLClientSocketFactory(SSLContext context) {
		System.err.println(getClass()+" ctor runs");
		this.context = context;
	}

	public Socket createSocket(String host, int port) 
		throws IOException { 
		System.err.println("creating client socket");
		// ThreadTool.threadInfo();
		// return new DebugSSLSocket(context, host, port); 
		return new SSLSocket(context, host, port); 
	} 

	private void writeObject(ObjectOutputStream out)
		throws IOException {
		System.err.println(this.getClass()
			+" writeObject sends nothing");
	}

	private void readObject(ObjectInputStream out)
		throws IOException {
		// no non-transient state to read...
		System.err.println(this.getClass()
			+" readObject supplies fresh, hokey SSLContext");
		context = new SSLContext();	// transient field
		SSLPolicyInt policy = new SSLPolicyInt();
		policy.acceptUnverifiableCertificates(true);
		context.setPolicy(policy);
		context.loadRootCertificates("/u/jonh/puretls-0.9b1/root.pem");
		context.loadEAYKeyFile("/u/jonh/puretls-0.9b1/client.pem","password");
	}
} 
