package ssh;

import java.io.*;
import java.net.*; 
import java.rmi.server.*; 
import COM.claymoresystems.ptls.*;

/**
 * An adaptor to use my SSH channels with RMI from JDK 1.2, where your
 * own socket factories can supply the channels over which RMI
 * communicates.
 */
public class SSHServerSocketFactory 
	implements RMIServerSocketFactory, Serializable { 

	transient SSHContext context;

	public SSHServerSocketFactory(SSHContext context) {
		this.context = context;
	}

	public ServerSocket createServerSocket(int port) 
		throws IOException { 
		// return new DebugSSHServerSocket(context, port); 
		return new SSHServerSocket(context, port); 
	} 

	private void writeObject(ObjectOutputStream out)
		throws IOException {
		System.err.println(this.getClass()
			+" writeObject sends nothing");
	}

	private void readObject(ObjectInputStream out)
		throws IOException {
		// no non-transient state to read...
		System.err.println(this.getClass()
			+" readObject supplies fresh, hokey SSHContext");
		context = SSHContext.getDefault();	// transient field
	}
} 
