package ssh;

import java.io.*;
import java.net.*; 
import java.rmi.server.*; 
import COM.claymoresystems.ptls.*;
import COM.claymoresystems.sslg.*;

/**
 * An adaptor to use my SSH channels with RMI from JDK 1.2, where your
 * own socket factories can supply the channels over which RMI
 * communicates.
 */
public class SSHClientSocketFactory 
	implements RMIClientSocketFactory, Serializable { 

	transient SSHContext context;

	SSHContext getContext() {
		if (context==null) {
			context = SSHContext.getDefault();	// fill in the transient field
		}
		return context;
	}

	public SSHClientSocketFactory() {
		System.err.println(getClass()+" USELESS ctor runs");
	}

	public SSHClientSocketFactory(SSHContext context) {
		this.context = context;
	}

	public Socket createSocket(String host, int port) 
		throws IOException { 
		return new SSHOptSocket(getContext(), host, port); 
	} 
} 
