package ssh.RSA;

import ssh.*;
import java.io.FileOutputStream;
import java.io.DataOutputStream;

/**
 * A Unix command-line interface for creating new RSA key pairs.
 */
public class main {
	public static void main(String[] args) {
		try {
			if (args[0].equals("-newpair")) {
				FileOutputStream fos;
				String filebase = args[1];
				RSAKey[] pair = Keygen.generateKeys(new SshRandom());
				fos = new FileOutputStream(filebase+".private");
				pair[0].writeSsh(new DataOutputStream(fos));
				fos.close();
				fos = new FileOutputStream(filebase+".public");
				pair[1].writeSsh(new DataOutputStream(fos));
				fos.close();
			} else {
				System.err.println("Unrecognized option "+args[0]);
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}
