package ssh;

/**
 * This class defines the constants used in ssh protocol
 * packets for ssh version 2. Sadly, they're totally different than ssh
 * version 1, to the point that SSH Inc's idea of interoperability is
 * to fire up the v.1 executable when needed to talk to a v1 remote
 * end.<p>
 * 
 * So I'm not actually implementing v2 at all. I have an implementation
 * of v1 in here, but my main use of ssh, in Jon's "SRP" (Secure RMI
 * Protocol) is something that looks like v1, but with some of my own
 * messages, and v2-style channels.
 * 
 * Source: ssh 2.0.13/lib/sshproto/sshmsgs.h
 * 
 * @license This code is Copyright 1999 Jon Howell. It is available for
 * use under the GNU Public License, available at:
 * http://www.gnu.org/copyleft/gpl.html
 * 
 * @author Jon Howell <jonh@cs.dartmouth.edu>
 * @rcs $Id: Protocol2.java,v 1.3 2000/05/26 06:17:33 jonh Exp $
 * @classSummaryOnly true
 */

public class Protocol2 {
	/* Maximum length of packet payload, including packet type. */
	public static final int SSH_MAX_PAYLOAD_LENGTH = 32768;
	
	/* Packet numbers for the SSH transport layer protocol. */
	public static final int SSH_MSG_DISCONNECT = 1;
	public static final int SSH_MSG_IGNORE = 2;
	public static final int SSH_MSG_UNIMPLEMENTED = 3;
	public static final int SSH_MSG_DEBUG = 4;
	public static final int SSH_MSG_SERVICE_REQUEST = 5;
	public static final int SSH_MSG_SERVICE_ACCEPT = 6;
	
	public static final int SSH_MSG_KEXINIT = 20;
	public static final int SSH_MSG_NEWKEYS = 21;
	
	/* Numbers 15-19 for KEX packets. = Different KEX methods may reuse;
	 = message numbers in this range. */
	public static final int SSH_FIRST_KEX_PACKET = 30;
	
	/* Double encrypting key exchange */
	
	public static final int SSH_MSG_KEXDE_HOSTKEY = 30;
	public static final int SSH_MSG_KEXDE_SESSIONKEY = 31;
	
	/* Diffie-Hellman key exchange */
	
	public static final int SSH_MSG_KEXDH_INIT = 30;
	public static final int SSH_MSG_KEXDH_REPLY = 31;
	
	
	public static final int SSH_FIRST_SERVICE_PACKET = 50;
	
	
	/* Packet numbers for the SSH userauth protocol. */
	public static final int SSH_FIRST_USERAUTH_PACKET = 50;
	public static final int SSH_MSG_USERAUTH_REQUEST = 50;
	public static final int SSH_MSG_USERAUTH_FAILURE = 51;
	public static final int SSH_MSG_USERAUTH_SUCCESS = 52;
	public static final int SSH_MSG_USERAUTH_BANNER = 53;
	
	public static final int SSH_FIRST_USERAUTH_METHOD_PACKET = 60;
	public static final int SSH_LAST_USERAUTH_METHOD_PACKET = 79;
	public static final int SSH_LAST_USERAUTH_PACKET = 79;
	
	/* Packet numbers for various authentication methods. */
	
	/* Password authentication */
	public static final int SSH_MSG_USERAUTH_PASSWD_CHANGEREQ = 60;
	public static final int SSH_MSG_USERAUTH_PASSWD_CHANGEREPLY = 61;
	
	/* Challenge-response authentication */
	public static final int SSH_MSG_USERAUTH_CHALLENGE = 60;
	
	/* SecurID authentication */
	public static final int SSH_MSG_USERAUTH_SECURID_PINREQ = 60;
	public static final int SSH_MSG_USERAUTH_SECURID_PINREPLY = 61;
	
	/* Public key authentication */
	public static final int SSH_MSG_USERAUTH_PK_OK = 60;
	
	/* #define SSH_FIRST_USERAUTH_SERVICE_PACKET = 30 */
	
	/* Packet numbers for the SSH connection protocol. */
	public static final int SSH_MSG_GLOBAL_REQUEST = 80;
	public static final int SSH_MSG_REQUEST_SUCCESS = 81;
	public static final int SSH_MSG_REQUEST_FAILURE = 82;
	public static final int SSH_MSG_CHANNEL_OPEN = 90;
	public static final int SSH_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
	public static final int SSH_MSG_CHANNEL_OPEN_FAILURE = 92;
	public static final int SSH_MSG_CHANNEL_WINDOW_ADJUST = 93;
	public static final int SSH_MSG_CHANNEL_DATA = 94;
	public static final int SSH_MSG_CHANNEL_EXTENDED_DATA = 95;
	public static final int SSH_MSG_CHANNEL_EOF = 96;
	public static final int SSH_MSG_CHANNEL_CLOSE = 97;
	public static final int SSH_MSG_CHANNEL_REQUEST = 98;
	public static final int SSH_MSG_CHANNEL_SUCCESS = 99;
	public static final int SSH_MSG_CHANNEL_FAILURE = 100;
	
	public static final int SSH_MSG_RESERVED = 255;
	
	/* Debug message types */
	public static final int SSH_DEBUG_DEBUG = 0;
	public static final int SSH_DEBUG_DISPLAY = 1;
	
	/* Disconnection reasons */
	
	public static final int SSH_DISCONNECT_HOST_NOT_ALLOWED_TO_CONNECT = 1;
	public static final int SSH_DISCONNECT_PROTOCOL_ERROR = 2;
	public static final int SSH_DISCONNECT_KEY_EXCHANGE_FAILED = 3;
	public static final int SSH_DISCONNECT_HOST_AUTHENTICATION_FAILED = 4;
	public static final int SSH_DISCONNECT_MAC_ERROR = 5;
	public static final int SSH_DISCONNECT_COMPRESSION_ERROR = 6;
	public static final int SSH_DISCONNECT_SERVICE_NOT_AVAILABLE = 7;
	public static final int SSH_DISCONNECT_PROTOCOL_VERSION_NOT_SUPPORTED = 8;
	public static final int SSH_DISCONNECT_HOST_KEY_NOT_VERIFIABLE = 9;
	public static final int SSH_DISCONNECT_CONNECTION_LOST = 10;
	public static final int SSH_DISCONNECT_BY_APPLICATION = 11;
	public static final int SSH_DISCONNECT_AUTHENTICATION_ERROR = 12;
	
	/* Extended channel data types. */
	
	public static final int SSH_EXTENDED_DATA_STDERR = 1;
	
	/* Channel open result codes. */
	
	public static final int SSH_OPEN_OK = 0;
	public static final int SSH_OPEN_ADMINISTRATIVELY_PROHIBITED = 1;
	public static final int SSH_OPEN_CONNECT_FAILED = 2;
	public static final int SSH_OPEN_UNKNOWN_CHANNEL_TYPE = 3;
	public static final int SSH_OPEN_RESOURCE_SHORTAGE = 4;
}
