package ssh;

/**
 * This class defines the constants used in ssh version 1 protocol
 * packets.<p>
 * 
 * Source: draft-ylonen-ssh-protocol-00.txt
 * 
 * @license This code is Copyright 1999 Jon Howell. It is available for
 * use under the GNU Public License, available at:
 * http://www.gnu.org/copyleft/gpl.html
 * 
 * @rcs $Id: Protocol.java,v 1.4 2000/05/26 06:17:32 jonh Exp $
 * 
 * @author Jon Howell <jonh@cs.dartmouth.edu> 
 * @classSummaryOnly true
 */
public class Protocol {
	// Message types (RFC draft pp. 19-30)
	public static final int SSH_MSG_NONE                       = 0;
	public static final int SSH_MSG_DISCONNECT                 = 1;
	public static final int SSH_SMSG_PUBLIC_KEY                = 2;
	public static final int SSH_CMSG_SESSION_KEY               = 3;
	public static final int SSH_CMSG_USER                      = 4;
	public static final int SSH_CMSG_AUTH_RHOSTS               = 5;
	public static final int SSH_CMSG_AUTH_RSA                  = 6;
	public static final int SSH_SMSG_AUTH_RSA_CHALLENGE        = 7;
	public static final int SSH_CMSG_AUTH_RSA_RESPONSE         = 8;
	public static final int SSH_CMSG_AUTH_PASSWORD             = 9;
	public static final int SSH_CMSG_REQUEST_PTY               = 10;
	public static final int SSH_CMSG_WINDOW_SIZE               = 11;
	public static final int SSH_CMSG_EXEC_SHELL                = 12;
	public static final int SSH_CMSG_EXEC_CMD                  = 13;
	public static final int SSH_SMSG_SUCCESS                   = 14;
	public static final int SSH_SMSG_FAILURE                   = 15;
	public static final int SSH_CMSG_STDIN_DATA                = 16;
	public static final int SSH_SMSG_STDOUT_DATA               = 17;
	public static final int SSH_SMSG_STDERR_DATA               = 18;
	public static final int SSH_CMSG_EOF                       = 19;
	public static final int SSH_SMSG_EXITSTATUS                = 20;
	public static final int SSH_MSG_CHANNEL_OPEN_CONFIRMATION  = 21;
	public static final int SSH_MSG_CHANNEL_OPEN_FAILURE       = 22;
	public static final int SSH_MSG_CHANNEL_DATA               = 23;
	public static final int SSH_MSG_CHANNEL_CLOSE              = 24;
	public static final int SSH_MSG_CHANNEL_CLOSE_CONFIRMATION = 25;
	public static final int SSH_SMSG_X11_OPEN                  = 27;
	public static final int SSH_CMSG_PORT_FORWARD_REQUEST      = 28;
	public static final int SSH_MSG_PORT_OPEN                  = 29;
	public static final int SSH_CMSG_AGENT_REQUEST_FORWARDING  = 30;
	public static final int SSH_SMSG_AGENT_OPEN                = 31;
	public static final int SSH_MSG_IGNORE                     = 32;
	public static final int SSH_CMSG_EXIT_CONFIRMATION         = 33;
	public static final int SSH_CMSG_X11_REQUEST_FORWARDING    = 34;
	public static final int SSH_CMSG_AUTH_RHOSTS_RSA           = 35;
	public static final int SSH_MSG_DEBUG                      = 36;
	public static final int SSH_CMSG_REQUEST_COMPRESSION       = 37;
	public static final int SSH_CMSG_MAX_PACKET_SIZE           = 38;
	public static final int SSH_CMSG_AUTH_TIS                  = 39;
	public static final int SSH_SMSG_AUTH_TIS_CHALLENGE        = 40;
	public static final int SSH_CMSG_AUTH_TIS_RESPONSE         = 41;
	public static final int SSH_CMSG_AUTH_KERBEROS             = 42;
	public static final int SSH_SMSG_AUTH_KERBEROS_RESPONSE    = 43;
	public static final int SSH_CMSG_HAVE_KERBEROS_TGT         = 44;

	// Cipher methods (RFC draft p. 5-6)
	public static final int SSH_CIPHER_NONE	= 0;
	public static final int SSH_CIPHER_IDEA	= 1;
	public static final int SSH_CIPHER_DES	= 2;
	public static final int SSH_CIPHER_3DES	= 3;
	public static final int SSH_CIPHER_TSS	= 4;
	public static final int SSH_CIPHER_RC4	= 5;

	// Authentication methods (RFC draft p. 10)
	public static final int SSH_AUTH_RHOSTS     = 1;
	public static final int SSH_AUTH_RSA        = 2;
	public static final int SSH_AUTH_PASSWORD   = 3;
	public static final int SSH_AUTH_RHOSTS_RSA = 4;
}
