package ssh;

import java.io.*;

/**
 * This class is an Authenticator that simply sends a password over the
 * encrypted channel.<p>
 * 
 * Source: for ssh protocol definition:
 * draft-ylonen-ssh-protocol-00.txt especially pages 13, 21.
 * 
 * @license This code is Copyright 1999 Jon Howell. It is available for
 * use under the GNU Public License, available at:
 * http://www.gnu.org/copyleft/gpl.html
 * 
 * @author jonh@cs.dartmouth.edu
 * 
 * @rcs $Id: PasswordAuthenticator.java,v 1.1 1999/12/07 20:32:06 jonh
 * Exp $
 */

public abstract class PasswordAuthenticator
	extends Authenticator {
	String password;

	public PasswordAuthenticator(String password) {
		this.password = password;
		// would be nice to be able to destroy the sensitive password,
		// but Java strings are 'immutable.'
	}

	public void authenticate(BinaryPacketInputStream binaryIn,
							BinaryPacketOutputStream binaryOut)
		throws IOException {
		BinaryPacketOut bpo = binaryOut.newPacket();
		bpo.setType(Protocol.SSH_CMSG_AUTH_PASSWORD);
		bpo.writeString(password);
		binaryOut.writePacket(bpo);
	}
}
