package ssh;

/**
 * Purpose: An instance of a subclass of this abstract class can engage
 * the ssh server in an authentication dialog. Used to plug in different
 * user-authentication mechanisms.<p>
 * 
 * Source: for ssh protocol definition:
 * draft-ylonen-ssh-protocol-00.txt
 *
 * @license This code is Copyright 1999 Jon Howell. It is available for
 * use under the GNU Public License, available at:
 * http://www.gnu.org/copyleft/gpl.html
 * 
 * @author Jon Howell <jonh@cs.dartmouth.edu>
 * @rcs $Id: Authenticator.java,v 1.2 2000/05/22 01:35:45 jonh Exp $
 * 
 */
public abstract class Authenticator {
	public abstract void authenticate(BinaryPacketInputStream binaryIn,
							BinaryPacketOutputStream binaryOut)
		throws java.io.IOException;
}
