package sdsi;
import sdsi.sexp.*;

/**
 * The <code>(*)</code> special form tag. Used to say that any member of the
 * set is acceptable. It's sort of a hack; I don't understand why
 * SDSI couldn't use the empty list (). (Something about list datatype
 * vs. this tag, which matches both lists and raw bytestrings?)
 * On top of that hack, there's also the (tag *) case, where the *
 * is just a bytestring, not a list containing that single bytestring.
 * It means the same thing, but has a different representation. Gack.
 */
class TEStar
	extends TESpecial {

	String mySpecialToken() { return ""; }

	TEStar() {
		super(new SexpList(
				new Sexp[] {
					new SexpString("*")
				}
			)
		);
	}

	public TEStar(SexpList l)
		throws SexpParseException {
		if (l.size()!=1
			|| !(l.elementAt(0) instanceof SexpString)
			|| !((SexpString) l.elementAt(0)).stringContent().equals("*")) {
			throw new SexpParseException("(*) form not encoded properly");
		}
		srep = l;
	}

	public TagExpression intersect(TagExpression otherTE) {
		return otherTE;
	}
}
