package sdsi;
import sdsi.sexp.*;

/**
 * A helper class to parse a TagExpression out of an Sexp. This would
 * go into the TagExpression interface, except that's an interface.
 */
class TEParse {
	static TagExpression parse(Sexp s)
		throws SexpParseException{
		if (s instanceof SexpString) {
			return new TEByteString((SexpString) s);
		} else { // s is a SexpList
			SexpList l = (SexpList) s;
			if (l.elementAt(0) instanceof SexpList) {
				// seems like an arbirtrary restriction to me [jonh]
				throw new SexpParseException(
					"First element in tag can't be list");
			} else if (((SexpString)l.elementAt(0))
				.stringContent().equals("*")) {
				return TESpecial.parse(l);
			} else {
				return new TEList(l);
			}
		}
	}
}
