package sdsi;
import sdsi.sexp.*;

/**
 * The null tag.
 * This implementation uses a 'psuedo-special-form' (* null) as
 * a representation; that way we can have a concrete object
 * to represent a null authorization. It's formally sound, I think
 * (I have this great semantics in mind for SPKI tags :v), and
 * it's better than the alternative I tried before: throwing a
 * NullTagException whenever we encounter one of these critters.
 */

class TENull
	extends TESpecial {

	static TENull singleton=null;

	public static TENull getNull() {
		if (singleton==null) {
			singleton = new TENull();
		}
		return singleton;
	}

	String mySpecialToken() { return "null"; }

	/**
	 * Null doesn't intersect with anything.
	 */
	public TagExpression intersect(TagExpression otherTE) {
		return this;
	}

	TENull() {
		super(
			new SexpList(
				new Sexp[] {
					new SexpString("*"),
					new SexpString("null")
				}
			)
		);
	}
}
