package sdsi;
import sdsi.sexp.*;

/**
 * A singleton bytestring, the basic user-defined element of a tag.
 * (There are other types of user-defined elements that appear in
 * special-form tags; those aren't TEByteStrings.)
 */
class TEByteString
	implements TagExpression {

	SexpString value;

	public TEByteString(SexpString s) {
		value = s;
	}

	public Sexp getSexp() {
		return value;
	}

	public TagExpression intersect(TagExpression otherTE) {
		// The table of proof cases in the dissertation
		// suggests a total order among
		// TagExpression implementations that I'm implicitly
		// using to avoid double-coding.
		//
		// I think TESet is the highest in the order (it can intersect
		// with everybody including itself), and this is the
		// lowest (it only intersects with itself, and defers all
		// other decisions to the other expression). Hmm, TENull is
		// pretty high, too -- it trivally intersects with all classes.
		if (otherTE instanceof TEByteString) {
			TEByteString otherString = (TEByteString) otherTE;
			if (this.value.equals(otherString.value)) {
				return this;
			} else {
				return TENull.getNull();
			}
		} else {
			return otherTE.intersect(this);
		}
	}
}
