package sdsi;

import sdsi.sexp.*;

/**
 * A class of objects used by TERange to encapsulate the various
 * range-checking behaviors of (* range) tags.
 */
abstract class RangeComparator {
	/**
	 * Does this comparator include the given value?
	 */
	abstract boolean includes(SexpString sexpString);

	/**
	 * Return a comparator that only accepts values accepted by both
	 * this comparator and otherRC.
	 */
	abstract RangeComparator intersect(RangeComparator otherRC);

	SexpString operator;
	SexpString limit;

	/**
	 * constructor used by RCAny
	 */
	RangeComparator() {}

	/**
	 * general constructor
	 */
	RangeComparator(SexpString operator, SexpString limit)
		throws SexpParseException {
		this.operator = operator;
		char b = operator.stringContent().charAt(0);
		char e = operator.stringContent().charAt(1);
		if ((b!='g' && b!='l') || (e!='t' && e!='e')) {
			throw new SexpParseException("malformed range operator "
				+operator.stringContent());
		}
		this.limit = limit;
	}

	SexpString getOperator() {
		return operator;
	}

	SexpString getLimit() {
		return limit;
	}

	/**
	 * returns true if this comparator represents a lower bound (it's a
	 * gt or ge test).
	 */
	boolean wantGreater() {
		return operator.stringContent().charAt(0) == 'g';
	}

	/**
	 * returns true if this comparator allows equality with the limit
	 * value
	 */
	boolean acceptEquality() {
		return operator.stringContent().charAt(1) == 'e';
	}
}
