package sdsi;

import sdsi.sexp.*;

/**
 * The friendly comparator -- accepts any input. Used
 * when a <code>(* range ...)</code> tag doesn't specify one of its bounds
 * to avoid requiring a special case in the comparison code in TERange.
 */
class RCAny
	extends RangeComparator {
	boolean includes(SexpString sexpString) {
		return true;
	}

	RangeComparator intersect(RangeComparator otherRC) {
		return otherRC;
	}

	/**
	 * Operator and limit fields are unused; fortunately TERange is
	 * bright enough to check for this class specifically and avoid
	 * trying to use them.
	 */
	RCAny() { }

	static RCAny singleton=null;

	static RCAny getInstance() {
		if (singleton==null) {
			singleton = new RCAny();
		}
		return singleton;
	}
}
