package relational.email;

import relational.*;
import java.awt.*;
import java.awt.dnd.*;
import java.awt.datatransfer.*;
import java.io.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 * A panel that displays a graphical (tree) representation of the query
 * that currently defines the index view.
 */
public class WherePanel
	extends JPanel
	implements DropTargetListener {

	Where query;
	JLabel wlabel;
	ChangeListener clistener;

	public WherePanel() {
		new DropTarget(this,
			DnDConstants.ACTION_COPY_OR_MOVE,
			this);

		wlabel = new JLabel();
		wlabel.setEnabled(false);
		wlabel.setText("Empty");
		add(wlabel);
		wlabel.setDropTarget(getDropTarget());
	}

	public void setQuery(Where query) {
		if (!query.equals(this.query)) {
			this.query = query;
			wlabel.setText(query.toString());
			fireChangeEvent();
		}
	}

	public Where getQuery() {
		return query;
	}

	public void addChangeListener(ChangeListener cl) {
		this.clistener = ChangeEventMulticaster.add(this.clistener, cl);
	}

	public void removeChangeListener(ChangeListener cl) {
		this.clistener = ChangeEventMulticaster.remove(this.clistener, cl);
	}

	protected void fireChangeEvent() {
		if (clistener!=null) {
			clistener.stateChanged(new ChangeEvent(this));
		}
	}

	// DropTargetListener support
	public void drop(DropTargetDropEvent e) {
		try {
			Where where = (Where) e.getTransferable()
				.getTransferData(TransferableFilter.filterFlavor);
			e.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
			setQuery(where);
		} catch (IOException ex) {
			ex.printStackTrace();
		} catch (UnsupportedFlavorException ex) {
			System.err.println("Drop denied! "+ex);
			e.rejectDrop();
		}
	}
    public void dragEnter(DropTargetDragEvent e) { }
    public void dragExit(DropTargetEvent e) { }
    public void dragOver(DropTargetDragEvent e) { }
    public void dropActionChanged(DropTargetDragEvent e) { }
}
