package relational.email;

import java.awt.datatransfer.*;
import relational.*;

/**
 * A draggable entity (Transferable) that lets the user drag Filters to
 * and from the tree view of the current query.
 */
public class TransferableFilter
	implements Transferable {

	static DataFlavor filterFlavor
		= new DataFlavor(TransferableFilter.class, "Database Filter");
	static DataFlavor[] supportedFlavors = { filterFlavor };

	Where where;

	public TransferableFilter(Where where) {
		this.where = where;
	}

	public Where getWhere() { return where; }

	// Transferable support
	public Object getTransferData(DataFlavor flavor)
		throws UnsupportedFlavorException {
		if (flavor == filterFlavor) {
			return where;
		}
		throw new UnsupportedFlavorException(flavor);
	}

	public DataFlavor[] getTransferDataFlavors() {
		return supportedFlavors;
	}

	public boolean isDataFlavorSupported(DataFlavor flavor) {
		return flavor == filterFlavor;
	}
}
