package relational.email;

import javax.swing.table.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.Enumeration;
import java.util.Hashtable;
import java.awt.event.*;
import java.awt.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;
import java.util.EventObject;

/**
 * Need to modify the BasicTableUI to not snarf drag events,
 * or else it ends up fighting with the drag-n-drop code.
 *
 * @author jonh (Jon Howell)
 */
public class DragTableUI extends BasicTableUI
{
	public class MouseInputHandler
		extends BasicTableUI.MouseInputHandler {

		// don't follow drags. They just confuse us when there's
		// a drag-n-drop.
		public void mouseDragged(MouseEvent e) {
			// TODO: drag-n-drop bug produces infinite bogus drag events
			// since mouseReleased is lost. (but even when mouse isn't moving.)
			// System.err.println("absorbing mouseDragged event");
		}
	}

	protected MouseInputListener createMouseInputListener() {
		return new MouseInputHandler();
	}

	public void dragStarted() {
		// can't just call MouseInputListener's setValueIsAdjusting
		// method because it's private (grr)
		table.getSelectionModel().setValueIsAdjusting(false);
		table.getColumnModel().getSelectionModel().setValueIsAdjusting(false);
	}

	public static ComponentUI createUI(JComponent c) {
		return new DragTableUI();
	}
}
