package relational.email;

import java.rmi.RemoteException;
import relational.*;

/**
 * Part of the Database schema for email. A Body row carries the body
 * text of a message, and connects it to a specific {@link Message}
 * object.
 */
public class Body
	extends ClumpRelational {

	public String body;
	public Object msg_fk;

	// Foreign Key boilerplate
	transient protected Message msgCached;
	public Message getMsg() {
		if (msgCached==null) {
			msgCached = (Message) resolveForeignKey(Message.class, msg_fk);
		}
		return msgCached;
	}

	public void setMsg(Message m) {
		msg_fk = m.primaryKey;
		msgCached = m;
	}

/*
	public static Body newRow(Database d)
		throws RemoteException {
		return (Body) d.newRow(Body.class);
	}
*/
	public Body(Database db) { super(db); }

	public static FieldDescriptor f_reference;
	public static FieldDescriptor f_primaryKey;
	public static FieldDescriptor f_body;
	public static FieldDescriptor f_msg;
	static {
		try {
			f_reference	= FieldDescriptor.get(Body.class);
			f_primaryKey= FieldDescriptor.getPrimaryKey(Body.class);
			f_body		= FieldDescriptor.get(Body.class.getField("body"));
			f_msg		= FieldDescriptor.get(Body.class.getField("msg_fk"));
		} catch (NoSuchFieldException ex) { }
	}
}
