package relational;

import java.util.Hashtable;
import java.util.Vector;
import java.lang.reflect.Field;

/**
 * Disjunction of two where subclauses.
 *
 * @classConcise true
 */
public class WhereOr
	extends WhereBinary {

	public WhereOr() {
	}

	public WhereOr(Where w1, Where w2) {
		super(w1, w2);
	}

	public boolean includes(Row ro, Database db) {
		return w1.includes(ro, db) || w2.includes(ro, db);
	}

	public String toString() {
		return "("+w1+" or "+w2+")";
	}

	public String getShortName() { return "OR"; }
}
