package relational;

import java.util.Hashtable;
import java.util.Vector;
import java.lang.reflect.Field;
import Tools.Text;

/**
 * Abstract superclass for Where clauses with two subclauses (binary
 * operators).
 *
 * @classConcise true
 */
public abstract class WhereBinary
	extends Where {
	Where w1, w2;

	public WhereBinary() {
	}

	public WhereBinary(Where w1, Where w2) {
		this.w1 = w1;
		this.w2 = w2;
	}

	public String indentedString(int d) {
		return getShortName()
			+"\n"+Text.indent(d, w1.indentedString(d))
			+"\n"+Text.indent(d, w2.indentedString(d));
	}

	public int getChildCount() {
		return 2;
	}

	public Object getChild(int index) {
		if (index==0) {
			return w1;
		} else if (index==1) {
			return w2;
		} else {
			throw new IllegalArgumentException(getClass()+" has only 2 children");
		}
	}

	public void setChild(int index, Object child) {
		if (index==0) {
			w1 = (Where) child;
		} else if (index==1) {
			w2 = (Where) child;
		} else {
			throw new IllegalArgumentException(getClass()+" has only 2 children");
		}
	}
}
