package relational;

import java.util.Hashtable;
import java.util.Vector;
import java.lang.reflect.Field;
import Tools.Text;

/**
 * Conjunction of two other where clauses.
 *
 * @classConcise true
 */
public class WhereAnd
	extends WhereBinary {

	public WhereAnd() {
	}

	public WhereAnd(Where w1, Where w2) {
		super(w1, w2);
	}

	public boolean includes(Row ro, Database db) {
		return w1.includes(ro, db) && w2.includes(ro, db);
	}

	public String toString() {
		return "("+w1+" and "+w2+")";
	}

	public String getShortName() { return "AND"; }
}
