package relational;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Vector;

/**
 * The abstract Where clause used to specify select statements.
 */
public abstract class Where
	implements Serializable {
	public static Where equals(FieldDescriptor fd, Object o) {
		return new WhereEquals(fd, o);
	}

	public static Where and(Where w1, Where w2) {
		return new WhereAnd(w1, w2);
	}

	public static Where always() {
		return new WhereAlways();
	}

	public abstract boolean includes(Row ro, Database db);

	public abstract int getChildCount();
	public abstract Object getChild(int index);
	public abstract void setChild(int index, Object child);
	public String getShortName() { return "whereAbstract"; }

	public Object clone()
		throws CloneNotSupportedException {
		// make this method public
		return super.clone();
	}

	public String indentedString(int level) {
		return toString();
	}

//	protected Object getField(Relational ro, Field f)
//		throws IllegalAccessException {
//		if (ro instanceof Aggregate) {
//			Aggregate a = (Aggregate) ro;
//			return a.getField(f);
//		} else {
//			return f.get(ro);
//		}
//	}
}
