package relational;

import java.io.Serializable;

/**
 * Description of a table (class), including a name to identify
 * <em>which</em> reference to the table we are talking about. Used in
 * SQL-like select statements that refer to the same table twice, for
 * example, when examining tree or other self-referential structures.
 * Used to build {@link FromClause}s.
 */
public class TableDescriptor
	implements Serializable, Comparable {

	String name;
	Class table;

	public TableDescriptor(String name, Class table) {
		this.name = name;
		this.table = table;
	}

	public int compareTo(Object o) {
		TableDescriptor cas = (TableDescriptor) o;
		return name.compareTo(cas.name);
	}

	public boolean equals(Object o) {
		if (!(o instanceof TableDescriptor)) {
			return false;
		}
		TableDescriptor cas = (TableDescriptor) o;
		return name.equals(cas.name)
			&& table.equals(cas.table);
	}

	// Silly things get used in HashSets, so we need a hashCode
	public int hashCode() {
		return name.hashCode() ^ table.hashCode();
	}
}
