package relational;

import COM.claymoresystems.ptls.*;
import proof.*;
import sdsi.*;
import ssl.*;

import java.io.*;
import java.net.*;
import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;

/**
 * Creates a remotely-accessible Database that is accessed using
 * RMI-over-SSL (PureTLS). (No particular client authorization mechanism
 * yet -- it turned out that I could never get SSL over RMI working well.)
 */
public class SSLDatabase {
	public static void main(String[] args) {
		try {
			if (System.getSecurityManager()==null) {
				System.setSecurityManager(new RMISecurityManager());
			}

			// TODO: should factor out some standard way of seeding
			// this context thing.
			// SfContext context = new SfContext();
			SSLContext context = new SSLContext();

			// server context *needs* a private key
			// SDSIKeyPair keypair = jp.Tool.generateKeyPair();
			// context.setPrivateKey(keypair.getPrivateKey());
			context.loadRootCertificates("/u/jonh/puretls-0.9b1/root.pem");
			context.loadEAYKeyFile("/u/jonh/puretls-0.9b1/server.pem","password");

			Database theDatabase = new InternalDatabase(context);
			InetAddress thisHost = InetAddress.getLocalHost();
			Naming.rebind("//"+thisHost.getHostName()+"/RMIDatabase",
				theDatabase);
			System.out.println("Database registered in RMI");
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}
