package relational;

import java.io.Serializable;
import java.util.Comparator;

/**
 * A numeric Comparator for sorting.
 */
public class NumericComparator implements Comparator, Serializable {
	public int compare(Object o1, Object o2) {
		if (o1 instanceof String) {
			o1 = Double.valueOf((String) o1);
		}
		if (o2 instanceof String) {
			o2 = Double.valueOf((String) o2);
		}
		double d1 = ((Number) o1).doubleValue();
		double d2 = ((Number) o2).doubleValue();
		return d1<d2 ? -1
			: d1>d2 ? 1
				: 0;
	}
}
