package relational;

import java.util.Vector;
import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * A database can do select-like operations. Relational objects need
 * to work with the database to get created, so the database can track
 * them.
 */
public interface Database
	extends Remote {

	/**
	 * Relational-capable classes call this method to have their
	 * object created. (A database "table" corresponds to a class,
	 * a "row" to an instance.)
	 */
//	public Object newRow(Class c)
//		throws RemoteException;

	/**
	 * All Relational objects have an 'update()' method that calls
	 * the database to let it know the object has changed. The database
	 * should ensure that any new info in the object is indexed
	 * and persistent at this point.
	 */
//	public void updateObject(Relational ro)
//		throws RemoteException;

	/**
	 * Do nothing. Verifies that the database server is accessible.
	 */
	public void noop()
		throws RemoteException;

	/**
	 * All Relational objects in ros[] should be of the same class.
	 * ros.length should be greater than 0. (duh)
	 */
	public void insert(Relational ro) throws RemoteException;
	public void insert(Relational[] ros) throws RemoteException;

	public void shutdown() throws RemoteException;

	public void update(Relational ro) throws RemoteException;
	public void update(Relational[] ros) throws RemoteException;

	/**
	 * Every database can perform the select() operation.
	 * It's neat-o because it can "invert" pointers.
	 */
	public ResultSet evaluateSelect(Select s)
		throws RemoteException;
	// public Vector select(Class fromClass, Where where)

	/**
	 * Hint to the database the fields you want indexed
	 */
	public void createIndex(FieldDescriptor fd)
		throws RemoteException;
}
