package proof;

import sdsi.*;
import sdsi.sexp.*;
import Tools.*;

/**
 * An S-expression that holds both a private and a public key in the
 * same file, so it's really easy to tell that they go together. 
 * This is a convenient way to package private keys so that we don't
 * lose track of the public key that it goes with.
 */
public class SDSIKeyPair
	extends SDSIObject {

	SDSIPublicKey publicKey;
	SDSIPrivateKey privateKey;

	public SDSIPublicKey getPublicKey() {
		return publicKey;
	}

	public SDSIPrivateKey getPrivateKey() {
		return privateKey;
	}

	/**
	 * Parse the given SexpList into a SDSIKeyPair object.
	 *
	 * @returns null if <CODE>l</CODE> does not represent a Proof
	 * we understand.
	 */
	public SDSIKeyPair(SexpList l)
		throws SexpParseException {
		Assert.assert(l.getType().equals(SDSIKeyPair.LABEL));
		privateKey = (SDSIPrivateKey)
			SDSIObject.principalParse(((SexpList) l.elementAt(1)), null);
		publicKey = (SDSIPublicKey)
			SDSIObject.principalParse(((SexpList) l.elementAt(2)), null);
		srep = l;
	}

	public SDSIKeyPair(SDSIPrivateKey privateKey, SDSIPublicKey publicKey) {
		this.privateKey = privateKey;
		this.publicKey = publicKey;
		Sexp[] sexpary = new Sexp[3];
		sexpary[0] = new SexpString(SDSIKeyPair.LABEL);
		sexpary[1] = privateKey.getSrep();
		sexpary[2] = publicKey.getSrep();
		srep = new SexpList(sexpary);
	}

	static final String LABEL = "public-key-pair";
}
