package proof;

// import java.util.*;
import Tools.*;

/**
 * An cache of proofs on the server side of a connection. It can replace
 * new proofs with older proofs that are identical in SDSI representation
 * but which have interesting transient data, such as the bit that indicates
 * that we already verified the proof. Useful for servers caching and
 * verifying proofs from clients.
 */
public class ProofCache {
//	HashMap proofMap = new HashMap();
	final int cacheSize = 10;
	LRUHashMap proofMap = new LRUHashMap(cacheSize, cacheSize, (float) 0.75);

	public Proof substitute(Proof parent) {
		// do we have an entire proof to replace parent with?
		Proof cachedProof = (Proof) proofMap.get(parent);
		if (cachedProof!=null) {
			// System.out.println("pc: found cached "+Prover2.staticGetName(cachedProof));
			return cachedProof;
		}

		// otherwise, try to replace each of parent's children
		Proof child;
		for (int i=0; (child=parent.getChildProof(i))!=null; i++) {
			Proof alternate = substitute(child);
			if (alternate!=child) {
				// System.out.println("pc: Substituted old "+Prover2.staticGetName(alternate)+" for new "+Prover2.staticGetName(child));
				parent = parent.substituteProof(i, alternate);
			}
		}

		// and then take this proof, which contains as many internal refs as
		// we know how to substitute, and cache it for next time.
		proofMap.put(parent, parent);
		// System.out.println("proof cache size "+proofMap.size());
		return parent;
	}

	public int size() {
		return proofMap.size();
	}
}
