package proof;

import java.util.*;
import sdsi.*;

/**
 * Continue a name chain along a Def edge.
 *
 * @deprecated part of the original {@link Prover} class.
 * {@link Prover2} is the tool clients should use now.
 */
public class DefNameNode extends NameNode {
	Def def;

	DefNameNode(NameNode next, Def def) {
		this.next = next;
		this.def = def;
	}

	public boolean hasDefs() {
		return true;
	}

	public SDSIPrincipal getPrincipal() {
		// TODO: this whole thing will break as soon as the Def subjects
		// get more complicated than just a public key. If they're
		// compound or a name chain themselves, we'll have to get
		// a lot smarter.
		return (SDSIPrincipal) def.getIssuer();
	}
	public Vector getNameVector() {
		Vector v = next.getNameVector();
		v.add(def.getName().getNameIndex(0));
		return v;
	}

	public void debugChain(Prover pr) {
		System.out.println("  "+pr.getName(getPrincipal())+"  "+def.hashCode());
		if (next!=null) {
			next.debugChain(pr);
		}
	}
}
