##############################################################################
## The general rules for building files                                     ##
##############################################################################

%.class : %.java
	CLASSPATH=$(CLASSPATH) javac -g $<

%_Skel.class %_Stub.class: %.class
#	CLASSPATH=$(CLASSPATH) java sun.rmi.rmic.Main -keepgenerated '$(THISPACKAGE).$(subst .class,,$<)'
	CLASSPATH=$(CLASSPATH) rmic -keepgenerated '$(THISPACKAGE).$(subst .class,,$<)'

##############################################################################
## all: The set of objects we build in this directory                       ##
##############################################################################

CLASSES = $(subst .java,.class,$(wildcard *.java))
JAVANAMES = $(patsubst %.class,$(THISPACKAGE).%,$(CLASSES))
#RMICANDIDATES = $(patsubst %.class,$(THISPACKAGE).%,$(wildcard *.class))
#RMICANDIDATES = $(patsubst %_Skel,,$(patsubst %_Stub,,$(JAVANAMES)))
#STUBCLASSES = $(patsubst %.class,%_Stub.class,$(REMOTECLASSES))

all: $(CLASSES) $(EXTRA) rmistubs subdirs

classpath:
	@echo $(CLASSPATH)

##############################################################################
## archiving rules (I should learn CVS)                                     ##
##############################################################################
#
# CI = ci -d -M -q -l -t-null -mnull
# 
# dir_ci:
# 	@mkdir -p RCS
# 	@$(CI) $(wildcard *.java) $(wildcard *.cpp) $(wildcard *.c) $(wildcard *.h) \
# 		$(wildcard README) $(wildcard makefile) $(wildcard profileOut)
# 
# master_ci:
# 	find . -type d | grep -v RCS | sed 's/^/(cd /' | sed 's/$$/ \&\& make dir_ci)/' | sh
# 
# #	@echo made: $^
SUBDIRMAKEFILES = $(wildcard */makefile)
SUBDIRS = $(subst /makefile,,$(SUBDIRMAKEFILES))

subdirs:
	@if [ "$(SUBDIRS)X" != "X" ]; then \
		for i in $(SUBDIRS)""; do \
			(cd $$i; make); \
		done; \
	fi

rmistubs:
	make `CLASSPATH=$(CLASSPATH) java ide.RMICheck $(THISPACKAGE)` nothing

# typing "make clean" is safer than typing "rm *.class", when one
# is in the habit of typing the string "*.java."
clean:
	rm -f *.class

PACKAGEDIRS = `cd $(PROJECT_ROOT); find -name makefile`
PACKAGES = $(PACKAGEDIRS)

doc: nothing
	CLASSPATH=$(CLASSPATH) PROJECT_ROOT=$(PROJECT_ROOT) $(PROJECT_ROOT)/javadoc-all-packages

# this target keeps make from looping when ide.RMICheck returns an
# empty list. (Otherwise we invoke make with no arguments, and it
# gets dizzy.)
nothing:
