package jp;

import java.util.*;
import javax.servlet.http.*;

/**
 * Implements the {@link javax.servlet.http.HttpServletRequest}
 * interface to allow a ServerRef to build a ``replacement'' request
 * based on an original request, but with changes overlaid.
 * This implementation lets you change the HTTP parameters (name/value
 * pairs that appear separated by '&' characters in a GET request, for
 * example).
 * 
 * Based on {@link ForwardedHttpServletRequest} (and hence {@link
 * ForwardedServletRequest}), this class overlays the caller's changes
 * encoded in a StateRef over the original request.
 * 
 * @author Jon Howell jonh@cs.dartmouth.edu 
 */

public class TweakedServletRequest
	extends ForwardedHttpServletRequest {
	StateRef ref;

	/**
	 * Define a new HttpServletRequest based on a prototype and a
	 * mapping of changes.
	 * 
	 * @param request The prototype request to be tweaked. @param ref
	 * The mapping of changes (tweaks) to the request.
	 */
	TweakedServletRequest(HttpServletRequest request, StateRef ref) {
		super(request);
		this.ref = ref;
	}

	/**
	 * Overrides getParameter to get a parameter from the
	 * <code>ref</code> tweaks supplied in the constructor.
	 */
    public String getParameter(String name) {
		return (String) ref.map.get(name);
	}

	/**
	 * Overrides the default method to get parameter names from the
	 * <code>ref</code> tweaks supplied in the constructor.
	 */
    public Enumeration getParameterNames() {
		return ref.getMapAsHashtable().keys();
	}

	/**
	 * @todo I don't really think about multivalued parameters right now.
	 */
    public String[] getParameterValues(String name) {
		return new String[] { getParameter(name) };
	}
}
