package jp;

/**
 * The SfUserAgent's protocol is modeled as a small state machine.
 * These are its states.
 */
public interface RequestStates {
	/**
	 * First authorization attempt is to see if this request is
	 * identical to one we've sent before.
	 */
	public static final int TRY_IDENTICAL = 10;

	/**
	 * The next-best thing after an identical request is a connection
	 * to a server that we share a MAC secret with; the request can be
	 * very quickly authenticated using a simple signature.
	 */
	public static final int TRY_MAC = 11;

	/**
	 * See if we have sent a request before to a prefix of this URL,
	 * and it required Snowflake authorization. If so, it is prudent to
	 * try using the same authority over this request that looks like a
	 * sub-request, to save a round trip.
	 */
	public static final int TRY_HINT = 12;

	/**
	 * We have no useful clues. Try sending the request without
	 * Snowflake authorization, and if Sf auth is required, the server
	 * will demand it.
	 */
	public static final int TRY_NOTHING = 13;

	/**
	 * Having decided what authorization mechanism we're going to use
	 * on this pass, send the request to the server.
	 */
	public static final int SEND_REQUEST = 14;

	/**
	 * The request has been answered, and we have no way to improve on
	 * it even if the answer was ``401 Unauthorized,'' so return the
	 * result to the client.
	 */
	public static final int REQ_DONE = 15;
}
