package jp;

import proof.*;

/**
 * A PageHistory contains the state associated with visiting a web
 * page.  It includes the Snowflake (HTTP with signed requests
 * protocol) authorization information, useful for delegating authority
 * over the page to another.
 */
public class PageHistory {
	/**
	 * The URL of the visited page.
	 */
	public String url;

	/**
	 * HTML document title, if known. (currently, I'm not parsing out
	 * of the response stream.)
	 */
	public String title = "";

	/**
	 * Indication of whether Snowflake authorization was used for this
	 * document, and its outcome.
	 */
	public int snowflakeStatus = SF_NOSFAUTH;

	/**
	 * The Snowflake proof used to access this document.  NULL when
	 * snowflakeStatus!=SF_SUCCESS.
	 */
	public Proof sfProof;


	/**
	 * loading this page did not require a Snowflake proof
	 * authorization
	 */
	public static final int SF_NOSFAUTH = 0;

	/**
	 * this page did require a Snowflake proof, but we couldn't produce
	 * it.
	 */
	public static final int SF_SFUNAUTH = 1;

	/**
	 * this page required a Snowflake proof, and we supplied it
	 */
	public static final int SF_SUCCESS = 2;
}
