package jp;

import proof.*;
import java.util.*;

/**
 * A History object maintains a list of PageHistory objects, used
 * to implement the history list in the PrincipalManager user interface.
 */
public class History {
	Vector history;	// Vector of PageHistory's
	int size;

	/**
	 * Create a History list.
	 *
	 * @param size maximum number of history entries to maintain.
	 */
	public History(int size) {
		history = new Vector(size);
		this.size = size;
		history.setSize(size);
	}

	/**
	 * Insert a page reference in the history list. The oldest page is
	 * discarded.
	 */
	public void addHistory(PageHistory h) {
		history.insertElementAt(h, 0);
		history.setSize(size);
	}

	/**
	 * Retrieve an iterator that returns {@link PageHistory} objects in
	 * reverse chronological order (newest first).
	 */
	public Iterator iterator() {
		return history.iterator();
	}

	/**
	 * Look up a PageHistory object by URL. Used by PrincipalManager
	 * when trying to map a clicked URL back to the PageHistory object
	 * that carries references to the Snowflake authorization
	 * information used when the page was accessed.
	 */
	public PageHistory findPage(String url) {
		for (int i=0; i<history.size(); i++) {
			PageHistory ph = (PageHistory) history.elementAt(i);
			if (ph!=null && url.equals(ph.url)) {
				return ph;
			}
		}
		return null;
	}
}
