package jp;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;

/**
 *
 * Convenince class to implement the
 * {@link javax.servlet.http.ServletRequest} interface
 * to allow a server to build a "replacement" request based on an
 * original request, but with certain changes overlaid.<p>
 *
 * All of the method implementations in this class forward to
 * the corresponding methods in the prototype object.
 *
 * @classConcise true
 * @author Jon Howell jonh@cs.dartmouth.edu
 */

public class ForwardedServletRequest
	implements ServletRequest {

	ServletRequest request;

	/**
	 * Create a request based on a prototype request.
	 * 
	 * @param request the prototype which will supply values for methods
	 * not overridden by a subclass method of this object.
	 */
	ForwardedServletRequest(ServletRequest request) {
		this.request = request;
	}

    public Object getAttribute(String name)
		{ return request.getAttribute(name); }
    public Enumeration getAttributeNames()
		{ return request.getAttributeNames(); }
    public String getCharacterEncoding ()
		{ return request.getCharacterEncoding(); }
    public int getContentLength()
		{ return request.getContentLength(); }
    public String getContentType()
		{ return request.getContentType(); }
    public ServletInputStream getInputStream() throws IOException
		{ return request.getInputStream(); }
    public String getParameter(String name)
		{ return request.getParameter(name); }
    public Enumeration getParameterNames()
		{ return request.getParameterNames(); }
    public String[] getParameterValues(String name)
		{ return request.getParameterValues(name); }
    public String getProtocol()
		{ return request.getProtocol(); }
    public String getScheme()
		{ return request.getScheme(); }
    public String getServerName()
		{ return request.getServerName(); }
    public int getServerPort()
		{ return request.getServerPort(); }
    public BufferedReader getReader () throws IOException
		{ return request.getReader(); }
    public String getRemoteAddr()
		{ return request.getRemoteAddr(); }
    public String getRemoteHost()
		{ return request.getRemoteHost(); }
    public void setAttribute(String key, Object o)
		{ request.setAttribute(key, o); }
    public String getRealPath(String path)
		{ return request.getRealPath(path); }
}
