package jp;

import javax.servlet.*;
import javax.servlet.http.*;
import java.util.Enumeration;

/**
 *
 * Convenince class to implement the
 * {@link javax.servlet.http.HttpServletRequest} interface
 * to allow a Server to build a ``replacement'' request based on an
 * original request, but with certain changes overlaid.
 * Think of it as a way to implement ``union mount'' for a Request.<p>
 *
 * All of the method implementations in this class forward to
 * the corresponding methods in the prototype object.
 * A subclass need only override the methods it wishes to interpose upon.
 *
 * @classConcise true
 * @author Jon Howell jonh@cs.dartmouth.edu
 */

public class ForwardedHttpServletRequest
	extends ForwardedServletRequest
	implements HttpServletRequest {

	HttpServletRequest request;

	/**
	 * Create a proxy request object.
	 *
	 * @param request the request that should serve any request not
	 * overridden by (a subclass method of) this object.
	 */
	ForwardedHttpServletRequest(HttpServletRequest request) {
		super(request);
		this.request = request;
	}

    public String getAuthType()
		{ return request.getAuthType(); }
    public Cookie[] getCookies()
		{ return request.getCookies(); }
    public long getDateHeader(String name)
		{ return request.getDateHeader(name); }
    public String getHeader(String name)
		{ return request.getHeader(name); }
    public Enumeration getHeaderNames()
		{ return request.getHeaderNames(); }
    public int getIntHeader(String name)
		{ return request.getIntHeader(name); }
    public String getMethod()
		{ return request.getMethod(); }
    public String getPathInfo()
		{ return request.getPathInfo(); }
    public String getPathTranslated()
		{ return request.getPathTranslated(); }
    public String getQueryString()
		{ return request.getQueryString(); }
    public String getRemoteUser()
		{ return request.getRemoteUser(); }
    public String getRequestedSessionId()
		{ return request.getRequestedSessionId(); }
    public String getRequestURI()
		{ return request.getRequestURI(); }
    public String getServletPath()
		{ return request.getServletPath(); }
    public HttpSession getSession(boolean create)
		{ return request.getSession(create); }
    public HttpSession getSession()
		{ return request.getSession(); }
    public boolean isRequestedSessionIdValid ()
		{ return request.isRequestedSessionIdValid(); }
    public boolean isRequestedSessionIdFromCookie ()
		{ return request.isRequestedSessionIdFromCookie(); }
    public boolean isRequestedSessionIdFromURL()
		{ return request.isRequestedSessionIdFromURL(); }
    public boolean isRequestedSessionIdFromUrl()
		{ return request.isRequestedSessionIdFromUrl(); }
}
