package Tools;

import java.util.*;

/**
 * Yet another tool for indenting text strings.
 */
public class Text {
	static int speedySize = 30;
	static String[] speedy = new String[speedySize];

	public static String indent(int d) {
		if (d>=speedySize) {
			return realIndent(d);
		} else if (speedy[d]==null) {
			speedy[d] = realIndent(d);
		}
		return speedy[d];
	}

	public static String indent(int d, String s) {
		String is = indent(d);
		StringBuffer out = new StringBuffer();
		StringTokenizer st = new StringTokenizer(s, "\n");
		while (st.hasMoreTokens()) {
			String line = st.nextToken();
			out.append(is);
			out.append(line);
			out.append('\n');
		}
		return out.toString();
	}

	protected static String realIndent(int d) {
		char[] c = new char[d];
		java.util.Arrays.fill(c, ' ');
		return new String(c);
	}
}
